/* global chrome */

chrome.options.opts.autoSave = false;

chrome.options.opts.about = `
<p>You can always check our <a href="https://www.youtube.com/channel/UCjzsx-_2HY_u3NBtBuj1cxQ" target="_blank">YouTube channel</a> for more detailed instruction videos about how to use our Amazing Relay extension.<br />
If you have any questions or complaints please <a href="https://amazingrelay.com/contact">contact us</a></p>

`;

chrome.options.opts.callback = (e) => {
    let keys = [
        'settings.key',
    ];
    chrome.storage.sync.get(keys, (items) => {
        let key = items['settings.key'];
    });
    chrome.runtime.sendMessage({"background": "settingsChanged"});
};

chrome.options.addTab('Settings', [
    {type: 'h3', desc: 'Time zone and licence key'},
    {name: 'key', 'type': 'text', 'desc': '<a target="_blank" href=\'https://amazingrelay.com/tarif\'>Activation key</a> (required after 10 days of free trial)'},

    {
        name: 'timezone',
        type: 'select',
        desc: 'Please pick the time zone that works best for you to use it along with the "<a target="_blank" href=\'https://amazingrelay.com/faq#102\'>Start date/time max</a>" setting',
        options: [
            {
                'desc': 'SELECT TIME ZONE HERE', value: '', 'selected': true
            },
            {'desc': 'Eastern Time (EDT or EST)', 'value': 'EDT'},
            {'desc': 'Central Time (CDT or CST)', 'value': 'CDT'},
            {'desc': 'Mountain Time (Arizona excluded) (MDT or MST)', 'value': 'MDT'},
            {'desc': 'Pacific Time (PDT or PST)', 'value': 'PDT'},
            {'desc': 'Arizona (always MST)', 'value': 'MST'},
        ]
    },

    {type: 'h3', desc: 'Hide/show page elements'},
    {type: 'checkbox', name: 'enableSimilarLoads', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Enable native similar loads</a>' },
    {type: 'checkbox', name: 'enableNotifications', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Enable native green notifications pop-up (bottom right corner</a>)', value: true, default: true},
    {type: 'checkbox', name: 'clear_filters', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Hide native "Create Post a Truck order" and "Clear filters" buttons on page load</a>'},
    {type: 'checkbox', name: 'hide_menu', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Hide native left menu on page load</a>'},
    {type: 'checkbox', name: 'hide_pop_ups', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Hide native information pop-ups on page load</a>'},
    {type: 'checkbox', name: 'hide_tabs', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Hide native "Recommended", "Search" and "Post A Truck" tabs on page load</a>'},
    {type: 'checkbox', name: 'hide_zip_codes', desc: '<a target="_blank" href=\'https://amazingrelay.com/faq#113\'>Remove zip-codes from all locations in the search results</a>'},
    
    {type: 'h3', desc: '↓↓↓ Scroll down for more settings ↓↓↓'},

    {type: 'h3', desc: 'Amazing Relay Standard plan features'},

    {
        name: 'nonAmazonLocations',
        type: 'select',
        desc: 'Please select how you want to highlight 3rd party (<a target="_blank" href=\'https://amazingrelay.com/faq#93\'>non-Amazon</a>) locations within the search results',
        options: [
            {'desc': 'Highlight non-Amazon names with blue color', value: 'blue_non_amazon', 'selected': true},
            {'desc': 'Replace non-Amazon names with three stars (***)', value: 'replace_non_amazon'},
            {'desc': 'Do nothing', value: 'off_non_amazon'},
        ]
    },

    {name: 'bufferTime', type: 'checkbox', desc: 'Enable "<a target="_blank" href=\'https://amazingrelay.com/faq#99\'>Min. stem time</a>"'},
    {name: 'deadhead', type: 'checkbox', desc: 'Enable "<a target="_blank" href=\'https://amazingrelay.com/faq#96\'>Deadhead Miles Coefficient</a>"'},
    {name: 'show_miles_time', type: 'checkbox', desc: 'Enable "<a target="_blank" href=\'https://amazingrelay.com/faq#97\'>Decrease max miles</a>"', value: true, default: true},
    {type: 'checkbox', name: 'fastbook', desc: 'Enable "<a target="_blank" href=\'https://amazingrelay.com/faq#114\'>Fastbook</a>" buttons (one-click book)'},

    {type: 'h3', desc: 'Amazing Relay PRO plan features'},
    {type: 'checkbox', name: 'enableMultipleLoadsSearch', desc: 'Enable <a target="_blank" href=\'https://amazingrelay.com/faq#124\'>multiple loads</a> search <a target="_blank" href=\'https://amazingrelay.com/tarif\'>PRO plan only</a>', value: true, default: true},
    {type: 'checkbox', name: 'enableCoefficient', desc: 'Enable <a target="_blank" href=\'https://amazingrelay.com/faq#123\'>coefficient</a> <a target="_blank" href=\'https://amazingrelay.com/tarif\'>PRO plan only</a>', value: true, default: true},
	
	{type: 'h3', desc: '!!! Load Board page needs to be reloaded (F5) for new settings to apply !!!'},
	{type: 'h3', desc: '↓↓↓ Click Save to apply changes ↓↓↓'}
]);

function linkHandler(e)
{
    e.preventDefault();
    e.stopPropagation();
    let target = e.target;
    let id = target.getAttribute('rel-anchor');
    document.getElementById(id).scrollIntoView();
}

let links = document.getElementsByClassName('anchor_link');
for (let i in links) {
    let link = links[i];
    link.onclick = linkHandler
}

document.addEventListener("DOMContentLoaded", function(event) {
    const params = new URLSearchParams(window. location. search)
    let section = params.get('section')
    if(section && document.getElementById(section)) {
        document.getElementById(section).scrollIntoView();
    }
});
