chrome.runtime.onInstalled.addListener(async () => {
    for (const cs of chrome.runtime.getManifest().content_scripts) {
        for (const tab of await chrome.tabs.query({url: cs.matches})) {
            chrome.scripting.executeScript({
                target: {tabId: tab.id},
                files: ["subscribe.js"]
            });
        }
    }
});

function stopAll(initialTabId) {
    chrome.tabs.query({}, function (tabs) {
        for (var i in tabs) {
            let tab = tabs[i];
            if (tab.id == initialTabId) {
                continue;
            }
            if (tab.url.search('/loadboard') > -1) {
                // let tabUrl = tab.url.replace(/#.*/, '');
                // chrome.tabs.update(tab.id, {url: tabUrl + '#stop'});
                chrome.tabs.sendMessage(tab.id, {action: 'stop'}, function (response) {
                });
            }
        }
    });
}

chrome.tabs.onUpdated.addListener(function (tabId, changeInfo, tab) {
    if (!changeInfo.url) {
        return;
    }
    if (changeInfo.url.indexOf('#bookThis') > -1) {
        chrome.tabs.update(tabId, {selected: true});
    }
    if (changeInfo.url.indexOf('#active') > -1) {
        chrome.tabs.update(tabId, {selected: true});
    }
    if (changeInfo.url.indexOf('#bookThisAndStop') > -1) {
        chrome.tabs.update(tabId, {selected: true});
        stopAll(tabId);
    }
    if (changeInfo.url.indexOf('#optionsPage') > -1) {
        let section = changeInfo.url.replace(/.*#optionsPage/, '');
        if (section) {
            section = '#' + section.replace('_', '');
        }
        chrome.tabs.create({url: chrome.runtime.getURL("options/options.html" + section)});
        let tabUrl = changeInfo.url.replace(/#.*/, '#');
        chrome.tabs.update(tabId, {url: tabUrl});
    }
});


function filterRequests(settings) {
    let allUrls = {
        'similarLoads': '*://relay.amazon.com/api/loadboard/similar*',
        'notifications': '*://relay.amazon.com/api/ons/v1/notifications*'
    }
    let urls = [
        '*://unagi.amazon.com/1/events/com.amazon.csm.csa.prod*',
        '*://unagi-na.amazon.com/1/events/com.amazon.csm.nexusclient.prod*',
        '*://fls-na.amazon.com/1/batch/1/OE*'
    ];
    console.log('Blocking requests: ', urls);
    let blockingRules = {
        rules: [],
        add: function (url, block) {
            block = block || false
            this.rules.push({
                url: url,
                block: block
            })
        },
    };
    urls.forEach((e) => blockingRules.add(e, true));

    let notificationDisabled = !(settings['settings.enableNotifications'] === undefined ? true : settings['settings.enableNotifications']);
    urls = urls.concat(allUrls.enableNotifications);
    blockingRules.add(allUrls.notifications, notificationDisabled);
    let similarDisabled = !(settings['settings.enableSimilarLoads'] === undefined ? false : settings['settings.enableSimilarLoads'])
    blockingRules.add(allUrls.similarLoads, similarDisabled);

    function stringToIntHash(str, upperbound, lowerbound) {
        let result = 0;
        for (let i = 0; i < str.length; i++) {
            result = result + str.charCodeAt(i);
        }

        if (!lowerbound) lowerbound = 0;
        if (!upperbound) upperbound = 500;

        return (result % (upperbound - lowerbound)) + lowerbound;
    }

    chrome.declarativeNetRequest.getDynamicRules().then(function (rules) {
        let rulesMap = {};
        rules.forEach((rule) => rulesMap[rule.condition.urlFilter] = rule);

        try {
            let removeRules = [];
            let addRules = [];
            blockingRules.rules.forEach((blockingRule) => {
                let blockingRuleUrl = blockingRule.url;
                let rule = rulesMap.hasOwnProperty(blockingRuleUrl) ? rulesMap[blockingRuleUrl] : null;

                if (rule) {
                    removeRules.push(rule.id);
                }
                if (blockingRule.block){
                    addRules.push(blockingRuleUrl);
                }
            });
            if (removeRules.length) {
                chrome.declarativeNetRequest.updateDynamicRules({
                    removeRuleIds: removeRules
                });
            }
            if (addRules.length) {
                let addRulesList = addRules.map((url) => {
                    return {
                        "id": stringToIntHash(url),
                        "action": {
                            "type": "block",
                        },
                        "condition": {
                            "urlFilter": url
                        }
                    }
                });
                chrome.declarativeNetRequest.updateDynamicRules({
                    addRules: addRulesList
                });

            }
        } catch (e) {
            console.error(e);
        }
    });
}

let initialTz = null;

function load(changed) {
    changed = changed === true || false;
    chrome.storage.sync.get(['settings.enableNotifications', 'settings.enableSimilarLoads', 'settings.timezone'], function (data) {
        let currentTz = null;
        if (data['settings.timezone']) {
            currentTz = data['settings.timezone'];
        }
        if (changed && currentTz !== initialTz) {
            initialTz = currentTz;
            update();
        }
        filterRequests(data);
    });
}

load();

function update() {
    chrome?.tabs?.query({"url": "https://relay.amazon.com/loadboard/search*"}, tabs => {
        tabs.forEach((tab) => {
            const tabId = tab.id;
            try {
                chrome.tabs.sendMessage(tabId, {
                    action: 'refresh',
                }, function (r) {
                });    
            } catch (e) {

            }
            
        })
    });
}
chrome.runtime.onMessage.addListener(function(message, sender, sendResponse) {
    sendResponse({ response: 'Message received!' });
    if (message.background === 'settingsChanged') {
        load(true);
    }

    return true;
});